<?php
/*--------------------------------------------------------------------
 OnGetShippingLinkEventInterface.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/
namespace Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Unit\Builders\Interfaces\SellingUnitBuilderInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ShippingLink;
use PriceDataInterface;

/**
 * Interface OnGetShippingLinkEventInterface
 * @package Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces
 */
interface OnGetShippingLinkEventInterface
{
    /**
     * @return ProductId
     */
    public function productId(): ProductId;
    
    /**
     * @return ModifierIdentifierCollectionInterface
     */
    public function modifiers(): ModifierIdentifierCollectionInterface;
    
    
    /**
     * @return SellingUnitBuilderInterface
     */
    public function builder() : SellingUnitBuilderInterface;
    
    /**
     * @return ShippingLink
     */
    public function shippingLink(): ShippingLink;
    
    /**
     * @param ShippingLink $shippingLink
     */
    public function setShippingLink(ShippingLink $shippingLink): void;
    
    /**
     * @return PriceDataInterface|null
     */
    public function xtcPrice(): ?PriceDataInterface;
}